clear all;
rho=1.1;cinf=340;uinf=30;u2=(uinf*0.039)^2;lf=0.082;
c=0.2032;b=1.8542;m=uinf/cinf;beta=sqrt(1-m^2);
f=logspace(1,4,100);omega=f*2*pi;k=omega/cinf;
 
x1=0;x2=10;x3=0;
rg=sqrt(x1^2+beta^2*(x2^2+x3^2));
k10=k/beta^2*(x1/rg-m);k30=k*x3/rg;
k0=k/beta^2;kappa=sqrt(k0.^2-k30.^2/beta^2);
ke=sqrt(pi)/lf*gamma(5/6)/gamma(1/3);
 
phi22=4/9/pi*u2^2/ke^2*(omega.^2/uinf^2+k30.^2)/ke^2./(1+(omega.^2/uinf^2+k30.^2)/ke^2).^(7/3);
lambda=-2*(1+i)*E2((kappa-m*k0-k10)*c)/pi./sqrt(omega/uinf+kappa*beta^2)./sqrt(kappa-m*k0-k10)/c;
spp=pi*rho^2*uinf*b*c^2*k.^2/8/rg^2*x2^2/rg^2.*phi22.*abs(lambda).^2;
spl3=10*log10(2*omega.*(2^(1/6)-2^(-1/6)).*spp/4e-10);

figure;h=semilogx(f,spl3,'k');
xlabel('f(Hz)');ylabel('SPL 1/3 re 20\muPa');

function res=E2(x)
res=fresnelc(sqrt(2*x/pi))+i*fresnels(sqrt(2*x/pi));
end